unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Microsoft.DirectX, Microsoft.DirectX.Direct3D,Microsoft.DirectX.Direct3DX;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  private
    urzadzenie : Device;
    wierzcholki: VertexBuffer;
  public
    function  InicjujGrafike: Boolean;
    procedure Rysuj;
  private
    function  UtworzBuforWierzch(var urzadzenie: Device): VertexBuffer;
    procedure WypelnijBuforWierzch(var bufor: VertexBuffer);
    procedure UstawMacierze;
    procedure UstawSwiatla;
    procedure UstawMaterial;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(592, 566);
  Self.Name := 'TWinForm';
  Self.Text := 'DirectX.NET Przykad 11';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

function TWinForm.InicjujGrafike: Boolean;
var
  parametry: PresentParameters;
begin
  try
    parametry:= PresentParameters.Create;
    parametry.Windowed:= True;
    parametry.SwapEffect:= Microsoft.DirectX.Direct3D.SwapEffect.Discard;
    parametry.EnableAutoDepthStencil:= true;
    parametry.AutoDepthStencilFormat:= DepthFormat.D16;

    urzadzenie := Device.Create(0, DeviceType.Hardware, Self.Handle,
      CreateFlags.SoftwareVertexProcessing, [parametry]);
    wierzcholki:=UtworzBuforWierzch(urzadzenie);
    Result:= true;
  except
    on DirectXException do Result:=false;
  end;
end;

procedure TWinForm.Rysuj;
begin
  if (urzadzenie=nil) then Exit;

  urzadzenie.Clear(ClearFlags.Target or ClearFlags.ZBuffer, System.Drawing.Color.White, 1.0, 0);
  urzadzenie.BeginScene;

  UstawMacierze;
  UstawSwiatla;
  UstawMaterial;

  urzadzenie.SetStreamSource(0, wierzcholki, 0);
  urzadzenie.DrawPrimitives(PrimitiveType.TriangleStrip, 0,5000-2);

  urzadzenie.EndScene;
  urzadzenie.Present;
end;

function TWinForm.UtworzBuforWierzch(var urzadzenie: Device): VertexBuffer;
var bufor: VertexBuffer;
begin
  urzadzenie.VertexFormat:= CustomVertex.PositionNormal.Format;

  bufor:= VertexBuffer.Create(typeof(CustomVertex.PositionNormal),
10000, urzadzenie, Usage.WriteOnly, CustomVertex.PositionNormal.Format, Pool.Default);
  WypelnijBuforWierzch(bufor);
  Result:=bufor;
end;

procedure TWinForm.WypelnijBuforWierzch(var bufor: VertexBuffer);
var
   wierzch    : Array[0..9999] of CustomVertex.PositionNormal;
   strumien   : GraphicsStream;
   i,k,offset : integer;
   theta,theta2,fi: real;
begin
  strumien :=  bufor.Lock(0, 0, LockFlags.None);
  for i:= 0 to 49 do
  begin
    offset:=i*2*50;
  	for k:= 0 to 49 do
    begin
      theta := (Math.PI*i)/49.0;
      theta2:= (Math.PI*(i+1))/49.0;
      fi    := (2.0*Math.PI*k)/49.0;
      wierzch[offset+2*k].Position:= Vector3.Create(Math.Sin(theta)*Math.Cos(fi),
                                                    Math.Sin(theta)*Math.Sin(fi),
                                                    Math.Cos(theta));
      wierzch[offset+2*k].Normal:= wierzch[offset+2*k].Position;
      wierzch[offset+2*k+1].Position:= Vector3.Create(Math.Sin(theta2)*Math.Cos(fi),
                                                      Math.Sin(theta2)*Math.Sin(fi),
                                                      Math.Cos(theta2));
      wierzch[offset+2*k+1].Normal:=wierzch[offset+2*k+1].Position;
    end;
  end;
  strumien.Write(wierzch);
  bufor.Unlock;
end;

procedure TWinForm.UstawMacierze;
var angle: real;
begin
  urzadzenie.Transform.View:= Matrix.LookAtLH(Vector3.Create( 0.0, 0.0, -5.0),
    Vector3.Create( 0.0, 0.0, 0.0), Vector3.Create( 0.0, 1.0, 0.0) );
  urzadzenie.Transform.Projection := Matrix.PerspectiveFovLH(
    Geometry.DegreeToRadian(45.0), 1.0, 1.0, 100.0);
end;

procedure TWinForm.UstawSwiatla;
begin
  urzadzenie.Lights[0].Diffuse  := Color.White;
  urzadzenie.Lights[0].Specular := Color.White;
  urzadzenie.Lights[0].&Type    := LightType.Directional;
  urzadzenie.Lights[0].Direction:= Vector3.Create(0, 1, 1);
  urzadzenie.Lights[0].Update();
  urzadzenie.Lights[0].Enabled  := true;
  urzadzenie.RenderState.SpecularEnable:= true;
end;

procedure TWinForm.UstawMaterial;
var
  material: Microsoft.DirectX.Direct3D.Material;
begin
  material  := Microsoft.DirectX.Direct3D.Material.Create;
  // Kula bdzie niebieska
  material.Diffuse := Color.Blue;
  // a rozbyski zwierciadlane biae
  material.Specular:= Color.White;
  material.SpecularSharpness:= 100.0;

  urzadzenie.Material:= material;
end;

end.
